using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

namespace cifXTest
{
    public partial class cifXFileExplorer : Form
    {
        private cifXUser cifXUser = new cifXUser();
        private cifxBase cifXBase = new cifxBase();

        private const UInt32 SYSDEVICEFILE = 0;
        private const UInt32 CHANNELFILE   = 1;

        public cifXFileExplorer()
        {
            InitializeComponent();
            if (cifXUser.hChannel == 0)
            {
                this.cmbChannel.SelectedIndex = 6;
                this.cmbChannel.Enabled       = true;
            }
            else
            {
                this.cmbChannel.SelectedIndex = (int)cifXUser.ActiveChannel;
                this.cmbChannel.Enabled       = false;
            }
        }

        private void GetChannelfiles()
        {
            UInt32 lret   = 0;
            UInt32 pvUser = 1000;
            string sFile  = null;
            UInt32 ulMode = 0;

            UInt32 ulChannel = (UInt32)this.cmbChannel.SelectedIndex;
            if (ulChannel == 6)
                ulChannel = 0;

            if (cifXUser.hChannel != 0)
                ulMode = CHANNELFILE;
            else
                ulMode = SYSDEVICEFILE;

            this.lstFileList.BeginUpdate();
            this.lstFileList.Items.Clear();

            if (ulMode == SYSDEVICEFILE)
            {
                lret = cifXUser.xSysdeviceFindFirstFile(ulChannel, ref pvUser);
                sFile = cifXBase.ByteArrayToString(cifXUser.CifXdirectoryEntry.szFilename);
                if( sFile.StartsWith(".")==false && lret == 0)
                    this.lstFileList.Items.Add(new ListViewItem(new string[] { sFile, 
                                                                           cifXUser.CifXdirectoryEntry.ulFilesize.ToString() }));
                this.txtError.Text = cifXBase.SetLastError(lret);
                do
                {
                    lret = cifXUser.xSysdeviceFindNextFile(ulChannel, ref pvUser);
                    sFile = cifXBase.ByteArrayToString(cifXUser.CifXdirectoryEntry.szFilename);
                    if(sFile.StartsWith(".")==false && lret == 0)
                        this.lstFileList.Items.Add(new ListViewItem(new string[] { sFile, 
                                                                               cifXUser.CifXdirectoryEntry.ulFilesize.ToString() }));
                    this.txtError.Text = cifXBase.SetLastError(lret);
                } while (lret == 0);
            }
            else
            {
                lret = cifXUser.xChannelFindFirstFile(ref pvUser);
                sFile = cifXBase.ByteArrayToString(cifXUser.CifXdirectoryEntry.szFilename);
                if(sFile.StartsWith(".")==false && lret == 0)
                    this.lstFileList.Items.Add(new ListViewItem(new string[] { sFile, 
                                                                           cifXUser.CifXdirectoryEntry.ulFilesize.ToString() }));
                this.txtError.Text = cifXBase.SetLastError(lret);
                do
                {
                    lret = cifXUser.xChannelFindNextFile(ref pvUser);
                    sFile = cifXBase.ByteArrayToString(cifXUser.CifXdirectoryEntry.szFilename);
                    if (sFile.StartsWith(".")==false && lret == 0)
                        this.lstFileList.Items.Add(new ListViewItem(new string[] { sFile, 
                                                                           cifXUser.CifXdirectoryEntry.ulFilesize.ToString() }));

                    this.txtError.Text = cifXBase.SetLastError(lret);
                } while (lret == 0);
            }
            this.lstFileList.EndUpdate();
        }

        private void cmbChannel_SelectedIndexChanged(object sender, EventArgs e)
        {
            GetChannelfiles();
        }

        private void btnRefresh_Click(object sender, EventArgs e)
        {
            GetChannelfiles();
        }

        private void btnUpload_Click(object sender, EventArgs e)
        {
            //not implemented yet
        }

        private void btnDelete_Click(object sender, EventArgs e)
        {
            //not implemented yet
        }
    }
}